#ifndef __gxframework_shared_h__
	#define __gxframework_shared_h__

#ifndef WIN32_LEAN_AND_MEAN
	#define WIN32_LEAN_AND_MEAN
#endif

#define NOMINMAX

#include <windows.h>

#pragma comment (lib, "opengl32.lib")

static const char* DummyWindowClassName = "GxFramework.DummyWindow";
static const char* WindowClassName = "GxFramework.Window";

#define ASSERTING 1
#define TRACING 1
#define DEBUGLOGGING 1

#ifdef _DEBUG
	#include <cstdio>
	#include <cassert>

	#pragma comment (linker, "/SUBSYSTEM:CONSOLE") // dziki temu wymuszamy konsole

	#if ASSERTING != 0
		#define ASSERT(x) assert(x)
	#endif

	#if TRACING != 0
		#define TRACE() std::printf("[Call Trace] %s\n", __FUNCTION__)
	#endif

	#if DEBUGLOGGING != 0
		#define DEBUGLOG(x) std::printf("[Debug Log] %s\n", x);
	#endif
#else
	#define ASSERT(x)
	#define TRACE()
	#define DEBUGLOG(x)
#endif

#define GXDELETE(x) if(x != NULL) { delete x; x = NULL; }


//? Co z linkowaniem statycznym? wtedy GXFRAMEWORK_DECLSPEC = extern...

#ifdef GXFRAMEWORK_EXPORTS
	#define GXFRAMEWORK_DECLSPEC __declspec(dllexport)
#else
	#define GXFRAMEWORK_DECLSPEC __declspec(dllimport)
#endif

#endif // ~__gxframework_shared_h__
